#include "connection_stats_sender.h"

#include <yandex_io/libs/json_utils/json_utils.h>

#include <json/json.h>

namespace quasar {

    ConnectionStatsSender::ConnectionStatsSender(std::shared_ptr<YandexIO::ITelemetry> telemetry, std::string_view endpointName)
        : telemetry_(std::move(telemetry))
        , endpointName_(endpointName)
    {
    }

    void ConnectionStatsSender::onConnectionStateChanged(bool connected) {
        if (connected_ == connected) {
            return;
        }

        const auto now = std::chrono::steady_clock::now();

        Json::Value event;
        event["endpointName"] = endpointName_;
        event["connected"] = connected_;
        event["duration"] = static_cast<uint64_t>(std::chrono::duration_cast<std::chrono::milliseconds>(now - ts_).count());

        telemetry_->reportEvent("connectionStats", quasar::jsonToString(event));

        ts_ = now;
        connected_ = connected;
    }

} // namespace quasar
