#pragma once

#include <yandex_io/libs/telemetry/telemetry.h>

#include <chrono>

namespace quasar {

    class ConnectionStatsSender {
    public:
        ConnectionStatsSender(std::shared_ptr<YandexIO::ITelemetry> telemetry, std::string_view endpointName);

        void onConnectionStateChanged(bool connected);

    private:
        const std::shared_ptr<YandexIO::ITelemetry> telemetry_;
        std::string endpointName_;
        bool connected_ = false;
        std::chrono::steady_clock::time_point ts_ = std::chrono::steady_clock::now();
    };

} // namespace quasar
