#pragma once

#include <yandex_io/libs/counters/locked_counters.h>
#include <yandex_io/libs/counters/enumerated_counter.h>

namespace quasar {
    // counter tracked for 5mins, 15mins, hour and a day
    template <typename Enum>
    using DefaultDailyCounter = LockedCountersOverPeriods<EnumeratedCounter<Enum, Enum::MAX_>, 300, 900, 3600, 24 * 3600>;

    using Uint64DefaultDailyCounter = LockedCountersOverPeriods<std::uint64_t, 300, 900, 3600, 24 * 3600>;
} // namespace quasar
