#pragma once

#include <array>
#include <cstdint>

namespace quasar {

    template <typename Enum, unsigned Size>
    class EnumeratedCounter {
        using Storage = std::array<std::uint64_t, Size>;
        Storage cnts;

    public:
        using EnumType = Enum;

        EnumeratedCounter()
            : cnts{}
        {
        }

        EnumeratedCounter(Enum fld)
            : cnts{}
        {
            cnts[fld] = 1;
        }

        EnumeratedCounter(std::initializer_list<Enum> lst)
            : cnts{}
        {
            for (auto idx : lst) {
                cnts[idx] = 1;
            }
        }

        EnumeratedCounter(Enum fld, unsigned cnt)
            : cnts{}
        {
            cnts[fld] = cnt;
        }

        EnumeratedCounter& operator+=(const EnumeratedCounter& a) {
            for (unsigned i = 0; i < cnts.size(); ++i) {
                cnts[i] += a.cnts[i];
            }
            return *this;
        }

        EnumeratedCounter& operator-=(const EnumeratedCounter& a) {
            for (unsigned i = 0; i < cnts.size(); ++i) {
                cnts[i] -= a.cnts[i];
            }
            return *this;
        }

        const Storage& get() const {
            return cnts;
        }

        static unsigned size() {
            return Size;
        }
    };

} // namespace quasar
