#pragma once

#include <json/json.h>

namespace quasar {

    template <typename Counters>
    Json::Value EnumCountersToJson(const Counters& src, std::initializer_list<std::string> names) {
        Json::Value result = Json::objectValue;
        auto addCounters = [&result, &src](unsigned id, const std::string& name) {
            Json::Value values = Json::arrayValue;
            for (auto& item : src) {
                values.append(item.get()[id]);
            }
            result[name] = values;
        };

        unsigned idx = 0;
        for (const auto& name : names) {
            if (idx >= src[0].size()) {
                break;
            }
            addCounters(idx, name);
            ++idx;
        }
        return result;
    }
} // namespace quasar
