#pragma once

#include <yandex_io/libs/counters/counters_over_periods.h>

#include <mutex>

namespace quasar {
    template <typename IncrementingType, unsigned... Periods_>
    class LockedCountersOverPeriods {
        mutable std::mutex mutex_;
        using ImplType = CountersOverPeriodsImpl<IncrementingType, SteadyClock5min, Periods_...>;
        ImplType impl_;

    public:
        using CounterType = IncrementingType;
        using Result = typename ImplType::Result;

        void increment(IncrementingType inc = 1) {
            std::scoped_lock<std::mutex> lock(mutex_);
            impl_.increment(inc);
        }

        Result getCounters() const {
            std::scoped_lock<std::mutex> lock(mutex_);
            return impl_.getCounters();
        }

        Result getUpdatedCounters() {
            std::scoped_lock<std::mutex> lock(mutex_);
            return impl_.getUpdatedCounters();
        }
    };
} // namespace quasar
