#pragma once

#include <memory>
#include <string>

namespace quasar {

    class SymmetricCrypto {
    public:
        virtual std::string encrypt(const std::string&) = 0;
        virtual std::string decrypt(const std::string&) = 0;
        virtual void changeSecret(const std::string&) = 0;
        virtual ~SymmetricCrypto() = default;
        using UniquePtr = std::unique_ptr<SymmetricCrypto>;

        static UniquePtr makeNull(); // this crypto does nothing
        static UniquePtr makeAES256(const std::string& /*cryptoKey*/);
        static UniquePtr makeAES256Locked(const std::string& /*cryptoKey*/); // same but threadsafe
        static UniquePtr makeAES128(const std::string& /*cryptoKey*/);
        static UniquePtr makeAES128Locked(const std::string& /*cryptoKey*/); // same but threadsafe
    };

} // namespace quasar
