#pragma once

#include "i_delay_timings_policy.h"

#include <chrono>
#include <optional>
#include <random>

namespace quasar {
    class BackoffRetriesWithRandomPolicy: public IBackoffRetries {
    public:
        static constexpr int DEFAULT_DELAY_MULTIPLIER = 2;

        BackoffRetriesWithRandomPolicy();

        BackoffRetriesWithRandomPolicy(uint32_t seed,
                                       int maxDelayMultiplier = DEFAULT_DELAY_MULTIPLIER);

        // note: if max(min)CheckPeriod is nullopt -> defaultCheckPeriod is used as max(min)
        void initCheckPeriod(std::chrono::milliseconds defaultCheckPeriod,
                             std::chrono::milliseconds spedUpCheckPeriod,
                             std::optional<std::chrono::milliseconds> maxCheckPeriod = std::nullopt,
                             std::optional<std::chrono::milliseconds> minCheckPeriod = std::nullopt) override;

        void updateCheckPeriod(std::optional<std::chrono::milliseconds> defaultCheckPeriod = std::nullopt,
                               std::optional<std::chrono::milliseconds> spedUpCheckPeriod = std::nullopt) override;

        std::chrono::milliseconds calcHttpClientRetriesDelay(int retryNum) override;

        std::chrono::milliseconds getDelayBetweenCalls() override;

        std::mt19937& getRandomGenerator();

        void resetDelayBetweenCallsToDefault() override;

        void spedUpDelayBetweenCalls() override;

        void increaseDelayBetweenCalls() override;

    protected:
        std::chrono::milliseconds defaultCheckPeriod_{0};
        std::chrono::milliseconds spedUpCheckPeriod_{0};
        std::chrono::milliseconds currentCheckPeriod_{0};
        std::chrono::milliseconds maxCheckPeriod_{0};
        std::chrono::milliseconds minCheckPeriod_{0};
        int maxDelayMultiplier_{DEFAULT_DELAY_MULTIPLIER};

        std::mt19937 randomGenerator_;
    };

} // namespace quasar
