#pragma once

#include <chrono>
#include <optional>

namespace quasar {
    class IBackoffRetries {
    public:
        virtual void initCheckPeriod(std::chrono::milliseconds defaultCheckPeriod,
                                     std::chrono::milliseconds spedUpCheckPeriod,
                                     std::optional<std::chrono::milliseconds> maxCheckPeriod = std::nullopt,
                                     std::optional<std::chrono::milliseconds> minCheckPeriod = std::nullopt) = 0;
        virtual void updateCheckPeriod(std::optional<std::chrono::milliseconds> defaultCheckPeriod = std::nullopt,
                                       std::optional<std::chrono::milliseconds> spedUpCheckPeriod = std::nullopt) = 0;
        virtual ~IBackoffRetries() = default;
        virtual std::chrono::milliseconds calcHttpClientRetriesDelay(int retryNum) = 0;
        virtual std::chrono::milliseconds getDelayBetweenCalls() = 0;
        virtual void resetDelayBetweenCallsToDefault() = 0;
        virtual void spedUpDelayBetweenCalls() = 0;
        virtual void increaseDelayBetweenCalls() = 0;
    };
} // namespace quasar
