#pragma once

#include "i_device.h"

#include <yandex_io/libs/configuration/configuration.h>
#include <yandex_io/libs/hal/hal.h>
#include <yandex_io/libs/telemetry/telemetry.h>

#include <memory>

namespace YandexIO {

    class Device: public IDevice {
    private:
        const DeviceID deviceId_;
        std::shared_ptr<Configuration> configuration_;
        std::shared_ptr<ITelemetry> telemetry_;
        std::unique_ptr<HAL> hal_;
        const std::optional<std::string> deviceColor_;
        const std::optional<std::string> platformRevision_;

    public:
        Device(
            DeviceID deviceId,
            std::shared_ptr<Configuration> configuration,
            std::shared_ptr<ITelemetry> telemetry,
            std::unique_ptr<HAL> hal,
            std::optional<std::string> deviceColor = std::nullopt,
            std::optional<std::string> platformRevision = std::nullopt);

        const DeviceID& deviceId() const override {
            return deviceId_;
        }

        std::string color() const override;

        std::string platform() override {
            return configuration()->getDeviceType();
        }

        Configuration* configuration() override {
            return configuration_.get();
        }

        std::shared_ptr<Configuration> sharedConfiguration() override {
            return configuration_;
        }

        const std::shared_ptr<ITelemetry>& telemetry() override {
            return telemetry_;
        }

        HAL* hal() override {
            return hal_.get();
        }

        std::string platformRevision() const override;

        /**
         * @brief acquire user agent, defined in configuration file (quasar.cfg)
         * NOTE: Not working without configuration pointer
         */
        std::string getUserAgent() const override;

        /**
         * @brief interface for a getting a shorter/simpler UserAgent
         * NOTE: method used for transition to the getUserAgent(), basically deprecated at birth
         */
        std::string getDeprecatedUserAgent() const override;
        std::string softwareVersion() const override;
    };

} // namespace YandexIO
