#pragma once

#include <memory>
#include <string>

namespace YandexIO {

    using DeviceID = std::string;
    class Configuration;
    class ITelemetry;
    class HAL;

    class IDevice {
    public:
        virtual ~IDevice() = default;
        virtual const DeviceID& deviceId() const = 0;
        virtual std::string color() const = 0;
        virtual std::string platform() = 0;
        virtual Configuration* configuration() = 0;
        virtual std::shared_ptr<Configuration> sharedConfiguration() = 0;
        virtual const std::shared_ptr<ITelemetry>& telemetry() = 0;
        virtual HAL* hal() = 0;
        virtual std::string platformRevision() const = 0;
        virtual std::string getUserAgent() const = 0;
        virtual std::string getDeprecatedUserAgent() const = 0;
        virtual std::string softwareVersion() const = 0;
    };

} // namespace YandexIO
