#pragma once

#include <yandex_io/libs/device/i_device.h>

namespace YandexIO::mock {

    class SimpleDevice: public YandexIO::IDevice {
    public:
        SimpleDevice(YandexIO::DeviceID deviceId, std::string platform)
            : deviceId_(std::move(deviceId))
            , platform_(std::move(platform))
        {
        }

    public: // YandexIO::IDevice
        const YandexIO::DeviceID& deviceId() const override {
            return deviceId_;
        }

        std::string platform() override {
            return platform_;
        }

        std::string softwareVersion() const override {
            throw std::runtime_error("Not implemented");
        }

        std::string color() const override {
            throw std::runtime_error("Not implemented");
        }

        Configuration* configuration() override {
            throw std::runtime_error("Not implemented");
        }

        std::shared_ptr<Configuration> sharedConfiguration() override {
            throw std::runtime_error("Not implemented");
        }

        const std::shared_ptr<ITelemetry>& telemetry() override {
            throw std::runtime_error("Not implemented");
        }

        HAL* hal() override {
            throw std::runtime_error("Not implemented");
        }

        std::string platformRevision() const override {
            throw std::runtime_error("Not implemented");
        }

        std::string getUserAgent() const override {
            throw std::runtime_error("Not implemented");
        }

        std::string getDeprecatedUserAgent() const override {
            throw std::runtime_error("Not implemented");
        }

    private:
        const YandexIO::DeviceID deviceId_;
        std::string platform_;
    };

} // namespace YandexIO::mock
