#include "keymaster_proxy_device_cryptography.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/cryptography/cryptography.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

using namespace quasar;

KeymasterProxyCryptography::KeymasterProxyCryptography(const Json::Value& config)
    : client_(std::make_unique<keymaster_proxy_client::KeymasterProxyClient>(getString(config, "keymasterProxySocketPath")))
{
    // nop
}

std::string KeymasterProxyCryptography::sign(std::string_view data) {
    return client_->sign(std::string(data));
}

std::string KeymasterProxyCryptography::getEncryptPublicKey() const {
    return client_->exportKey();
}

std::string KeymasterProxyCryptography::decrypt(std::string_view data) {
    return client_->decrypt(std::string(data));
}

std::string KeymasterProxyCryptography::getType() const {
    return "keymasterProxy";
}
