#pragma once

#include <yandex_io/libs/device_cryptography/device_cryptography.h>

#include <yandex_io/libs/keymaster_proxy_client/keymaster_proxy_client.h>

#include <json/json.h>

namespace quasar {
    /**
     * @brief TEE-backed implementation for DeviceCryptography
     *
     * Uses `KeymasterProxyClient` to access unix socket to access trusted app.
     *
     * @note path to socket is read from config from field `keymasterProxySocketPath`
     */
    class KeymasterProxyCryptography: public YandexIO::DeviceCryptography {
        std::unique_ptr<quasar::keymaster_proxy_client::KeymasterProxyClient> client_;

    public:
        explicit KeymasterProxyCryptography(const Json::Value& config);

        std::string sign(std::string_view data) override;
        std::string getEncryptPublicKey() const override;
        std::string decrypt(std::string_view data) override;

        std::string getType() const override;
    };
} // namespace quasar
