#include "plain_file_device_cryptography.h"

using namespace YandexIO;

PlainFileDeviceCryptography::PlainFileDeviceCryptography(const KeyPair& keys,
                                                         quasar::Cryptography::Padding rsaPadding)
    : publicKey_(keys.publicKey)
    , rsaPadding_(rsaPadding)
{
    cryptography_.setKeyPair(keys);
}

std::string PlainFileDeviceCryptography::sign(std::string_view data) {
    return cryptography_.sign(data);
}

std::string PlainFileDeviceCryptography::getEncryptPublicKey() const {
    return publicKey_;
}

std::string PlainFileDeviceCryptography::decrypt(std::string_view data) {
    return cryptography_.decrypt(data, rsaPadding_);
}

std::string PlainFileDeviceCryptography::getType() const {
    return "plainFile";
}
