#pragma once

#include <yandex_io/libs/device_cryptography/device_cryptography.h>

#include <yandex_io/libs/cryptography/cryptography.h>

namespace YandexIO {
    /**
     * @brief A simple DeviceCryptography implementation.
     *
     * This implementation uses an accessible private/public key pair.
     * Making the private key accessible to application is inherently insecure
     * and should not be used in production code.
     */
    class PlainFileDeviceCryptography: public DeviceCryptography {
        std::string publicKey_;
        quasar::Cryptography cryptography_;
        quasar::Cryptography::Padding rsaPadding_;

    public:
        using KeyPair = quasar::Cryptography::KeyPair;

        PlainFileDeviceCryptography(const KeyPair& keys,
                                    quasar::Cryptography::Padding rsaPadding = quasar::Cryptography::Padding::RSA_PKCS1_OAEP);

        std::string sign(std::string_view data) override;
        std::string getEncryptPublicKey() const override;
        std::string decrypt(std::string_view data) override;

        std::string getType() const override;
    };
} // namespace YandexIO
