#include "dispatcher.h"

#include <yandex_io/libs/quasar_client/quasar_client.h>

#include <cstdlib>
#include <string>

static std::string ProgName(int argc, char** argv) {
    (void)argc;

    std::string name(argv[0]);
    const auto pos = name.find_last_of('/');

    if (pos == std::string::npos) {
        return name;
    }

    return std::string(name.begin() + pos + 1, name.end());
}

void RunDispatchMainCustom(int argc, char** argv, const std::vector<DispatchMainEntry>& choices) {
    const auto progName = ProgName(argc, argv);

    for (const auto& choice : choices) {
        if (progName == choice.name) {
            std::exit(choice.function(argc, argv));
        }
    }
}

void RunDispatchMain(int argc, char** argv) {
    RunDispatchMainCustom(argc, argv, {
                                          {"quasar_client", RunQuasarClient},
                                      });
}
