#pragma once

#include <yandex_io/protos/model_objects.pb.h>

#include <json/json.h>

#include <ostream>
#include <vector>

namespace YandexIO {

    struct EqualizerConfig {
        struct Band {
            double freq{0.};
            double width{0.};
            double gain{0.};

            enum class Type {
                PEAK,
                LOW_SHELF,
                HIGH_SHELF
            };
            std::optional<Type> type;

            auto operator<=>(const Band&) const = default;
        };

        bool preventClipping = false;
        std::vector<Band> bands;
        std::string preset;

        Json::Value toJson() const;
        auto operator<=>(const EqualizerConfig&) const = default;

        static EqualizerConfig fromJson(const Json::Value& config);
        static EqualizerConfig fromProto(const quasar::proto::EqualizerConfig& config);
    };

    std::ostream& operator<<(std::ostream& os, const EqualizerConfig& config);

} // namespace YandexIO
