#include "errno_exception.h"

#include <cstring>
#include <sstream>
#include <string.h>

#include <util/system/error.h>

std::string quasar::strError(int errCode) {
    char buf[1024] = {0};
    LastSystemErrorText(buf, sizeof(buf), errCode);
    return buf;
}

using namespace quasar;

namespace {
    std::string formatErrorMessage(int errorCode, const std::string& actionName) {
        std::ostringstream out;
        out << actionName << ": " << strError(errorCode);
        out << " (" << errorCode << ')';
        return out.str();
    }
} // namespace

ErrnoException::ErrnoException(int errorCode, const std::string& actionName)
    : std::runtime_error(formatErrorMessage(errorCode, actionName))
{
}
