#pragma once

#include <cerrno>
#include <stdexcept>
#include <string>

namespace quasar {

    /**
     * @brief c++ wrapper for strerror_r from <string.h>
     */
    std::string strError(int errCode);

    class ErrnoException: public std::runtime_error {
    public:
        ErrnoException(int errorCode, const std::string& actionName);
    };

} // namespace quasar
