#pragma once

#include "galois_field.h"

#include <string>
#include <vector>

/**
 * <p>Represents a polynomial whose coefficients are elements of a GF.
 * Instances of this class are immutable.</p>
 *
 * <p>Port to C++ of Sean Owen's port to Java of C++ code.</p>
 *
 * @author William Rucklidge
 * @author Sean Owen
 * @author katayad (katayad@yandex-team.ru)
 */

namespace quasar {

    class GaloisFieldPolynomial {
    public:
        GaloisFieldPolynomial(GaloisField field, const std::vector<int>& coefficients);

        GaloisField getField() const;

        std::vector<int> getCoefficients() const;

        int getDegree() const;

        bool isZero() const;

        int getCoefficient(int degree) const;

        int evaluateAt(int a) const;

        GaloisFieldPolynomial addOrSubtract(const GaloisFieldPolynomial& other);

        GaloisFieldPolynomial multiply(const GaloisFieldPolynomial& other);

        GaloisFieldPolynomial multiply(int scalar);

        GaloisFieldPolynomial multiplyByMonomial(int degree, int coefficient);

        std::pair<GaloisFieldPolynomial, GaloisFieldPolynomial> divide(GaloisFieldPolynomial other);

        static GaloisFieldPolynomial buildMonomial(const GaloisField& field, int degree, int coefficient);

        std::string toString();

    private:
        GaloisField field_;
        std::vector<int> coefficients_;
    };

} // namespace quasar
