#pragma once

#include "galois_field.h"
#include "reed_solomon_encoder.h"

#include <iostream>

/**
 * <p>Implements Reed-Solomon decoding, as the name implies.</p>
 *
 * <p>Port to C++ of Sean Owen's Java code.</p>
 *
 * @author William Rucklidge
 * @author Sean Owen
 * @author David Olivier
 * @author katayad (katayad@yandex-team.ru)
 */

namespace quasar {

    class ReedSolomonDecoder {
    public:
        ReedSolomonDecoder() = default;

        explicit ReedSolomonDecoder(const GaloisField& field);

        void decode(std::vector<int>& received, int twoS) const;

    private:
        GaloisField field_;

        std::pair<GaloisFieldPolynomial, GaloisFieldPolynomial>
        runEuclideanAlgorithm(GaloisFieldPolynomial a, GaloisFieldPolynomial b, int R) const;

        std::vector<int> findErrorLocations(const GaloisFieldPolynomial& errorLocator) const;

        std::vector<int>
        findErrorMagnitudes(const GaloisFieldPolynomial& errorEvaluator, const std::vector<int>& errorLocations) const;
    };

} // namespace quasar
