#pragma once

#include "galois_field.h"
#include "galois_field_polynomial.h"

#include <iostream>
#include <vector>

/**
 * <p>Implements Reed-Solomon encoding, as the name implies.</p>
 *
 * <p>Port to C++ of Sean Owen's Java code.</p>
 *
 * @author William Rucklidge
 * @author Sean Owen
 * @author David Olivier
 * @author katayad (katayad@yandex-team.ru)
 */

namespace quasar {

    class ReedSolomonEncoder {
    public:
        ReedSolomonEncoder() = default;

        explicit ReedSolomonEncoder(const GaloisField& field);

        void encode(std::vector<int>& toEncode, int ecBytes) const;

    private:
        GaloisField field_;
        mutable std::vector<GaloisFieldPolynomial> cachedGenerators_;
        GaloisFieldPolynomial buildGenerator(uint degree) const;
    };

} // namespace quasar
