#include "ete_util.h"

#include <yandex_io/libs/base/utils.h>

#include <chrono>

Json::Value makeETEEvent(const std::string& eventId) {
    Json::Value result;
    appendETEHeader(eventId, result);

    return result;
}

void appendETEHeader(const std::string& eventId, Json::Value& value) {
    int64_t timestamp = std::chrono::duration_cast<std::chrono::milliseconds>(std::chrono::system_clock::now().time_since_epoch()).count();

    if (eventId.empty()) {
        // There must always be event id
        value["header"]["event_id"] = quasar::makeUUID();
    } else {
        value["header"]["event_id"] = eventId;
    }
    value["header"]["timestamp"] = timestamp;
}
