#include "directory_iterator.h"

#include <yandex_io/libs/errno/errno_exception.h>

#include <sys/stat.h>

namespace quasar {

    DirectoryIterator::DirectoryIterator(const std::string& path) {
        dp_ = opendir(path.c_str());
        if (nullptr == dp_) {
            throw ErrnoException(errno, "Cannot open directory '" + path + "'");
        }
        ep_ = readdir(dp_);
    }

    DirectoryIterator::~DirectoryIterator() {
        closedir(dp_);
    }

    bool DirectoryIterator::isValid() const {
        return ep_ != nullptr;
    }

    void DirectoryIterator::next() {
        ep_ = readdir(dp_);
    }

    std::string DirectoryIterator::currentEntryName() const {
        return ep_->d_name;
    }

    bool DirectoryIterator::isFile() const {
        return ep_->d_type == DT_REG;
    }

    bool DirectoryIterator::isDirectory() const {
        return ep_->d_type == DT_DIR;
    }

} // namespace quasar
