#pragma once

#include <string>

#include <dirent.h>

namespace quasar {

    class DirectoryIterator {
    public:
        explicit DirectoryIterator(const std::string& path);
        ~DirectoryIterator();

        bool isValid() const;
        void next();
        std::string currentEntryName() const;
        bool isFile() const;
        bool isDirectory() const;

    private:
        DIR* dp_ = nullptr;
        dirent* ep_ = nullptr;
    };

} // namespace quasar
