#pragma once

#include "backend_api.h"
#include "i_account_devices.h"

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/signals/signal_external.h>
#include <yandex_io/libs/threading/unique_callback.h>

#include <mutex>

namespace glagol {

    class AccountDevices: public IAccountDevices {
    public:
        AccountDevices(std::shared_ptr<BackendApi> /*backendApi*/, std::string accountDeviceCacheFile, bool updateSuspended);
        ~AccountDevices();

        bool setSettings(const BackendSettings& settings) override;
        void suspendUpdate() noexcept;
        bool resumeUpdate() noexcept override;
        bool scheduleUpdate() noexcept override;

    public: // IAccountDevices
        IBackendApi::DevicesMap devices() const noexcept override;
        IDeviceListChangedSignal& deviceListChangedSignal() noexcept override;

    private:
        void updateAccountDeviceList(int failCounter) noexcept;

        void loadAccountDeviceCacheUnsafe() noexcept;
        void saveAccountDeviceCacheUnsafe() noexcept;

    private:
        quasar::Lifetime serviceLifetime_;
        const std::shared_ptr<BackendApi> backendApi_;
        const std::string accountDeviceCacheFile_;
        const std::shared_ptr<quasar::NamedCallbackQueue> backendApiQueue_;

        quasar::SignalExternal<IDeviceListChangedSignal> deviceListChangedSignal_;

        mutable std::mutex mutex_;
        std::chrono::steady_clock::time_point lastTryTime_;
        bool backendSuspended_{false};
        quasar::UniqueCallback updateAccountDeviceList_;
        IBackendApi::DevicesMap accountDevices_;
    };

} // namespace glagol
