#pragma once
#include <yandex_io/libs/glagol_sdk/resolve_item.h>

#include <yandex_io/libs/signals/i_signal.h>
#include <yandex_io/libs/threading/lifetime.h>

#include <map>
#include <unordered_map>

namespace glagol {
    class IAvahiBrowseClient {
    public:
        using Item = ResolveItem;

        struct Error {
            int errorCode;
            std::string errorString;
        };

        using ResolvedItems = std::unordered_map<Item, Item::Info, Item::Hasher>;

        using IResolvedItemsChangedSignal = quasar::ISignal<const ResolvedItems&>;

        virtual ~IAvahiBrowseClient() = default;

        virtual IResolvedItemsChangedSignal& resolvedItemsChangedSignal() = 0;
    };

} // namespace glagol
