#pragma once
#include "backend_settings.h"
#include "i_backend_api.h"
#include "quasar_includes.h"

#include <yandex_io/libs/device/i_device.h>

#include <yandex_io/interfaces/auth/i_auth_provider.h>

namespace glagol {

    class BackendApi: public IBackendApi {
    public:
        using IBackendApi::Device;
        using IBackendApi::DevicesMap;

        using Settings = BackendSettings;

        BackendApi(std::shared_ptr<quasar::IAuthProvider> /*authProvider*/, std::shared_ptr<quasar::ISimpleHttpClient> backendClient, Settings settings);
        BackendApi(std::shared_ptr<quasar::IAuthProvider> /*authProvider*/, std::shared_ptr<YandexIO::IDevice> device);
        BackendApi(std::shared_ptr<quasar::IAuthProvider> /*authProvider*/, Settings settings, std::shared_ptr<YandexIO::IDevice> device);

        bool setSettings(Settings settings);
        Settings settings() const;

        DevicesMap getConnectedDevicesList() override;

        std::string getToken(const DeviceId& deviceId) override;

        bool checkToken(const std::string& token) override;
        TokenCheckResult checkToken2(const std::string& token) override;

        void invalidToken(const DeviceId& /*deviceId*/) override{};
        void invalidCert(const DeviceId& /*deviceId*/) override{};

    private:
        Json::Value checkAndParseResponse(const quasar::ISimpleHttpClient::HttpResponse& response);

        quasar::ISimpleHttpClient::Headers getHeaders() const;

        Settings settings_;
        std::shared_ptr<quasar::ISimpleHttpClient> backendClient_;
        std::shared_ptr<quasar::IAuthProvider> authProvider_;
    };

} // namespace glagol
