#pragma once

#include "backend_settings.h"
#include "i_backend_api.h"

#include <yandex_io/libs/device/i_device.h>

#include <yandex_io/interfaces/auth/i_auth_provider.h>

namespace glagol {

    class BackendApi2: public IBackendApi {
    public:
        virtual void setSettings(const glagol::BackendSettings& settings) = 0;
        virtual void setDevicesList(const DevicesMap& newDevicesList) = 0;
        virtual std::optional<DeviceId> hasDeviceInDeviceList(const std::string& id) const = 0;
    };

    std::shared_ptr<BackendApi2> createCachedBackendApi(std::shared_ptr<YandexIO::IDevice> device,
                                                        const glagol::BackendSettings& settings,
                                                        std::shared_ptr<quasar::IAuthProvider> authProvider,
                                                        std::function<void()> deviceListRequestCb,
                                                        const IBackendApi::DevicesMap& devices);

} // namespace glagol
