#include "conversation_model.h"

#include "quasar_includes.h"

YIO_DEFINE_LOG_MODULE("glagol_sdk");

using namespace glagol::model;
using namespace std::chrono;

Json::Value getCommand(const std::string& command) {
    Json::Value res;
    res["command"] = command;
    return res;
}

Json::Value RequestPayloadFactory::getShowAliceVisualStatePayload(const std::string& microphone) {
    Json::Value payload;
    payload["command"] = "showAliceVisualState";
    payload["microphone"] = microphone;
    return payload;
}

Json::Value RequestPayloadFactory::getPlayMusicPayload(const std::string& type, const std::string& id) {
    Json::Value payload;
    payload["command"] = "playMusic";
    payload["type"] = type;
    payload["id"] = id;
    return payload;
}

Json::Value RequestPayloadFactory::getStopPayload() {
    Json::Value payload;
    payload["command"] = "stop";
    return payload;
}

Json::Value RequestPayloadFactory::getPlayPayload() {
    Json::Value payload;
    payload["command"] = "play";
    return payload;
}

Json::Value RequestPayloadFactory::getNextPayload() {
    Json::Value payload;
    payload["command"] = "next";
    return payload;
}

Json::Value RequestPayloadFactory::getPrevPayload() {
    Json::Value payload;
    payload["command"] = "prev";
    return payload;
}

Json::Value RequestPayloadFactory::getSetVolumePayload(double newVolume) {
    Json::Value payload;
    payload["command"] = "setVolume";
    payload["volume"] = std::to_string(newVolume);
    return payload;
}

Json::Value RequestPayloadFactory::getStatusSubscribePayload(double interval) {
    Json::Value payload;
    payload["command"] = "subscribeStatus";
    payload["interval"] = std::to_string(interval);
    return payload;
}

Json::Value RequestPayloadFactory::getPingPayload() {
    Json::Value payload;
    payload["command"] = "ping";
    return payload;
}

IncomingMessage::IncomingMessage(const Json::Value& json) {
    parseFromJson(json);
}

IncomingMessage::IncomingMessage(const std::string& jsonString) {
    try {
        parseFromJson(quasar::parseJson(jsonString));
    } catch (const Json::Exception& e) {
        YIO_LOG_ERROR_EVENT("GsdkIncomingMessage.Constructor.JsonParseError", "Json parsing error: " << e.what() << " " << jsonString);
    }
}

void IncomingMessage::parseFromJson(const Json::Value& json) {
    try {
        id = json["id"].asString();
        sentTime = time_point<std::chrono::system_clock>(milliseconds(json["sentTime"].asInt64()));
        if (!json["requestId"].isNull()) {
            auto statusStr = json["status"].asString();
            ResponseStatus responseStatus;
            if (statusStr == "SUCCESS") {
                responseStatus = ResponseStatus::SUCCESS;
            } else if (statusStr == "FAILURE") {
                responseStatus = ResponseStatus::FAILURE;
            } else {
                responseStatus = ResponseStatus::UNSUPPORTED;
            }

            request = RequestInfo{
                json["requestId"].asString(),
                time_point<std::chrono::system_clock>(milliseconds(json["requestSentTime"].asInt64())),
                responseStatus,
            };
        }
        extra = json["extra"];
        supportedFeatures = json["supported_features"];
        experiments = json["experiments"];
    } catch (const Json::Exception& e) {
        YIO_LOG_ERROR_EVENT("GsdkIncomingMessage.ParseFromJsonError", "IncomingMessage parsing error: " << e.what() << " " << json);
    }
}
