#pragma once

#include <json/json.h>

#include <chrono>
#include <optional>

namespace glagol {
    namespace model {

        namespace RequestPayloadFactory {
            Json::Value getShowAliceVisualStatePayload(const std::string& microphone);
            Json::Value getPlayMusicPayload(const std::string& type, const std::string& id);
            Json::Value getStopPayload();
            Json::Value getPlayPayload();
            Json::Value getNextPayload();
            Json::Value getPrevPayload();
            Json::Value getSetVolumePayload(double newVolume);
            Json::Value getStatusSubscribePayload(double interval);
            Json::Value getPingPayload();
        } // namespace RequestPayloadFactory

        enum class ResponseStatus {
            SUCCESS,     // ok, all done
            FAILURE,     // we tried but failed
            UNSUPPORTED, // at the moment of processing message was obsolete or wrong
            TIMEOUT
        };

        struct RequestInfo {
            std::string id;
            std::chrono::system_clock::time_point sentTime;
            ResponseStatus responseStatus;
        };

        struct IncomingMessage {
            IncomingMessage() = default;
            explicit IncomingMessage(const Json::Value& json);
            explicit IncomingMessage(const std::string& jsonString);

            void parseFromJson(const Json::Value& json);

            std::string id;
            std::chrono::system_clock::time_point sentTime;
            std::optional<RequestInfo> request;
            Json::Value extra;
            Json::Value supportedFeatures;
            Json::Value experiments;
        };

    } // namespace model
} // namespace glagol
