#pragma once

#include <string>
#include <tuple>

namespace glagol {

    struct DeviceId {
        std::string id;
        std::string platform;

        struct Hasher {
            std::size_t operator()(const DeviceId& item) const {
                std::hash<std::string> hash_fn;
                return hash_fn(item.id) ^ hash_fn(item.platform);
            }
        };

        bool operator!() const {
            return id.empty() || platform.empty();
        }
        bool operator==(const DeviceId& rhs) const {
            return rhs.id == id && rhs.platform == platform;
        }

        bool operator<(const DeviceId& rhs) const {
            // NOLINTNEXTLINE(modernize-use-nullptr) false positive
            return std::tie(id, platform) < std::tie(rhs.id, rhs.platform);
        }
    };

} // namespace glagol
