#pragma once

#include "device_id.h"

#include <functional>
#include <string>

namespace glagol {
    class DiscoveredItem {
    public:
        enum class Protocol {
            IPV4,
            IPV6
        };
        struct ConnectionData {
            Protocol protocol;
            std::string uri; // host:port
            std::string tlsCertificate;
        };

        using OnDiscovery = std::function<void(ConnectionData)>;

        virtual void invalidCert() = 0; //! notfy discovery to return new cert on next discover(...)
        virtual void discover(OnDiscovery) = 0;
        virtual const DeviceId& getDeviceId() const = 0;
        virtual void stopDiscovery() = 0; //! OnDiscovery requested by ::discover(OnDiscovery) should not be called after that
        virtual ~DiscoveredItem() = default;
    };

    using DiscoveredItemPtr = std::shared_ptr<DiscoveredItem>;
} // namespace glagol
