#pragma once
#include "backend_api.h"
#include "i_account_devices.h"
#include "i_discovery.h"
#include "avahi_wrapper/i_avahi_browse_client.h"

#include <yandex_io/libs/signals/signal_external.h>
#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/libs/threading/unique_callback.h>

#include <functional>
#include <map>
#include <memory>
#include <set>
#include <string>
#include <vector>

namespace glagol {

    class Discovery: public IDiscovery {
    public:
        struct Settings {
            struct Filter {
                std::set<std::string> platforms;
                std::set<std::string> ids;
            };
            Filter filter;
            bool accountOnly{false};

            std::string serviceType = "_yandexio._tcp";
            std::string serviceNamePrefix = "YandexIOReceiver-";
        };

        Discovery(
            std::shared_ptr<IAccountDevices> accountDevices,
            std::shared_ptr<IAvahiBrowseClient> browseClient,
            Settings settings,
            std::function<void(const Result&)> onResultChanged);
        Discovery(
            std::shared_ptr<quasar::ICallbackQueue> lifecycle,
            std::shared_ptr<IAccountDevices> accountDevices,
            std::shared_ptr<IAvahiBrowseClient> browseClient,
            Settings settings);
        Discovery(const Discovery&) = delete;
        Discovery& operator=(const Discovery&) = delete;
        ~Discovery();

        Result devicesAround() const noexcept;
        IDevicesAroundHasChangedSignal& devicesAroundHasChangedSignal() override;

    private:
        void onUpdateOriginResult(const IAvahiBrowseClient::ResolvedItems& resolvedItems);
        void notifyAboutDiscoveredDevices();

        quasar::Lifetime lifetime_;
        const std::shared_ptr<quasar::ICallbackQueue> lifecycle_;
        const std::shared_ptr<IAccountDevices> accountDevices_;
        const std::shared_ptr<IAvahiBrowseClient> browseClient_;
        const Settings settings_;

        quasar::SignalExternal<IDevicesAroundHasChangedSignal> devicesAroundHasChangedSignal_;

        /*
         * Can be accessed only in lifecycle_ thread only
         */
        BackendApi::DevicesMap myDevices_;
        Result originResult_;

        /*
         * Protected by mutex
         */
        mutable std::mutex mutex_;
        Result publicResult_;
    };

} // namespace glagol
