#include <yandex_io/libs/glagol_sdk/quasar_includes.h>
#include <yandex_io/libs/glagol_sdk/avahi_wrapper/avahi_browse_client.h>

#include <iostream>

using namespace glagol;

class AvahiListener: public AvahiBrowseClient::Listener {
    void onBrowserFailure(const AvahiBrowseClient::Error& error) override {
        std::cout << "onBrowserFailure: " << error.errorString << std::endl;
    }
    void onBrowserNew(const AvahiBrowseClient::Item& item) override {
        std::cout << "onBrowserNew: " << item.name << " " << item.domain << " " << item.type << std::endl;
    }
    void onBrowserRemove(const AvahiBrowseClient::Item& item) override {
        std::cout << "onBrowserRemove: " << item.name << " " << item.domain << " " << item.type << std::endl;
    }
    void onResolveFailure(const AvahiBrowseClient::Item& item, const AvahiBrowseClient::Error& error) override {
        std::cout << "onResolveFailure: " << item.name << " " << item.domain << " " << item.type << std::endl;
        std::cout << "              " << error.errorString << std::endl;
    }
    void onNewResolved(const AvahiBrowseClient::Item& item, const AvahiBrowseClient::Item::Info& info) override {
        std::cout << "New resolved: " << item.name << " " << item.domain << " " << item.type << std::endl;
        std::cout << "              " << info.txt.at("deviceId") << " " << info.txt.at("platform") << " " << info.address << std::endl;
    }
    void onResolvedRemoved(const AvahiBrowseClient::Item& item, const AvahiBrowseClient::Item::Info& info) override {
        std::cout << "Removed: " << item.name << " " << item.domain << " " << item.type << std::endl;
        std::cout << "              " << info.txt.at("deviceId") << " " << info.txt.at("platform") << std::endl;
    }
};

int main(int argc, char* argv[]) {
    quasar::TerminateWaiter waiter;
    std::cout << "starting" << std::endl;
    AvahiBrowseClient client;
    auto listener = std::make_shared<AvahiListener>();
    std::cout << "adding" << std::endl;
    client.addListener(listener);
    waiter.wait();
}
