#include <yandex_io/libs/glagol_sdk/connector.h>
#include <yandex_io/libs/glagol_sdk/conversation_model.h>
#include <yandex_io/libs/glagol_sdk/gsdk_metrica.h>
#include <yandex_io/libs/glagol_sdk/quasar_includes.h>

#include <yandex_io/libs/device/defines.h>
#include <yandex_io/libs/device/device.h>

#include <iostream>

using namespace glagol;
using namespace quasar;

int main(int argc, char* argv[]) {
    Connector::Settings settings;
    settings.backend.api.url = "https://quasar.yandex.net/dev";
    if (argc == 1) {
        cout << "Enter device platform (ex. \"yandexmodule\")" << endl;
        cin >> settings.deviceId.platform;
        cout << "Enter device id" << endl;
        cin >> settings.deviceId.id;
        cout << "Enter oauth token" << endl;
        cin >> settings.backend.api.token;
    } else if (argc == 4) {
        settings.deviceId.platform = std::string(argv[1]);
        settings.deviceId.id = std::string(argv[2]);
        settings.backend.api.token = std::string(argv[3]);
    }

    Connector connector(glagol::GsdkMetrica::createAppMetrica());
    connector.setOnMessageCallback([](const model::IncomingMessage& response) {
        cout << "Received message: " << Json::FastWriter().write(response.extra) << endl;
    });
    connector.setOnStateChangedCallback([](Connector::State state) {
        std::string stateNames[5] = {
            "STOPPED",
            "DISCOVERING",
            "REQUESTING_BACKEND",
            "CONNECTING",
            "CONNECTED",
        };
        cout << "State changed: " << stateNames[(int)state] << endl;
    });

    connector.connect(settings);

    bool stopped = false;
    while (!stopped) { //  NOLINT
        cout << "Enter \"help\" for help" << endl;
        std::string command;
        cin >> command;
        if (command == "help") {
            std::cout << "Enter command:\n"
                         "help, PlayMusic, Stop, Play, Next, Prev, SetVolume, StatusSubscribe, Ping";
        } else if (command == "PlayMusic") {
            string type, id;
            cout << "Enter type:" << endl;
            cin >> type;
            cout << "Enter id:" << endl;
            cin >> id;
            connector.send(model::RequestPayloadFactory::getPlayMusicPayload(type, id));
        } else if (command == "Stop") {
            connector.send(model::RequestPayloadFactory::getStopPayload());
        } else if (command == "Play") {
            connector.send(model::RequestPayloadFactory::getPlayPayload());
        } else if (command == "Next") {
            connector.send(model::RequestPayloadFactory::getNextPayload());
        } else if (command == "Prev") {
            connector.send(model::RequestPayloadFactory::getPrevPayload());
        } else if (command == "SetVolume") {
            cout << "Enter volume (from 0.0 to 1.0):";
            double volume;
            cin >> volume;
            connector.send(model::RequestPayloadFactory::getSetVolumePayload(volume));
        } else if (command == "StatusSubscribe") {
            cout << "Enter interval:";
            double interval;
            cin >> interval;
            connector.send(model::RequestPayloadFactory::getStatusSubscribePayload(interval));
        } else if (command == "Ping") {
            connector.send(model::RequestPayloadFactory::getPingPayload());
        }
    }
};
