#include <yandex_io/libs/glagol_sdk/discovery.h>
#include <yandex_io/libs/glagol_sdk/quasar_includes.h>

#include <iostream>

using namespace glagol;

int main(int argc, char* argv[]) {
    quasar::TerminateWaiter waiter;

    Discovery::Settings settings;
    settings.backend.token = "lololol";
    settings.filter.platforms.insert("yandexmodule");
    auto discovery = Discovery::create(
        std::move(settings),
        [](const Discovery::Result& result) {
            std::cout << std::endl
                      << "Result changed!" << std::endl;
            for (const auto& pair : result.items) {
                const auto& deviceId = pair.first;
                const auto& item = pair.second;
                std::cout << item.name << " " << item.host << " " << item.port << std::endl;
                std::cout << "      " << deviceId.platform << " " << deviceId.id << std::endl;
            }
        });

    waiter.wait();
}
