#pragma once

#include "backend_settings.h"
#include "i_backend_api.h"

#include <yandex_io/libs/signals/i_signal.h>

namespace glagol {

    class IAccountDevices {
    public:
        using IDeviceListChangedSignal = quasar::ISignal<const IBackendApi::DevicesMap&>;

        virtual ~IAccountDevices() = default;

        virtual IBackendApi::DevicesMap devices() const noexcept = 0;

        virtual IDeviceListChangedSignal& deviceListChangedSignal() noexcept = 0;

        virtual bool setSettings(const BackendSettings& settings) = 0;

        virtual bool resumeUpdate() noexcept = 0;

        virtual bool scheduleUpdate() noexcept = 0;
    };

} // namespace glagol
