#pragma once

#include "device_id.h"
#include "role_types.h"

#include <map>

namespace glagol {

    class IDiscovery {
    public:
        struct Result {
            enum class Protocol { ipv4,
                                  ipv6 };

            struct Item {
                std::string name;
                std::string accountDeviceName; // name from backend if isAccountDevice is true. Ignored in ==.
                std::string host;
                std::string address;
                int port{0};
                std::string uri;
                bool isAccountDevice{false};
                bool cluster{false};
                Protocol protocol{Protocol::ipv4};
                GroupRole tandemRole{RoleNest::STAND_ALONE};
                GroupRole stereopairRole{RoleNest::STAND_ALONE};
                bool connectionActive{false};

                bool operator==(const Item& /*another*/) const noexcept = default;
            };
            std::map<DeviceId, Item> items; // amount of items is supposed to be small

            bool operator==(const Result& /*another*/) const;
        };

        using IDevicesAroundHasChangedSignal = quasar::ISignal<const Result&>;

        virtual IDevicesAroundHasChangedSignal& devicesAroundHasChangedSignal() = 0;
        virtual ~IDiscovery() = default;
    };

} // namespace glagol
