#include "indirect_account_devices.h"

using namespace glagol;

IndirectAccountDevices::IndirectAccountDevices()
    : deviceListChangedSignal_(
          [this](bool /*onConnect*/) {
              std::lock_guard<std::mutex> lock(mutex_);
              return std::make_tuple(devices_);
          }, lifetime_)
{
}

void IndirectAccountDevices::update(IBackendApi::DevicesMap newDevices) {
    bool changed = false;
    {
        std::lock_guard<std::mutex> lock(mutex_);
        if (devices_ != newDevices) {
            devices_ = std::move(newDevices);
            changed = true;
        };
    }

    if (changed) {
        deviceListChangedSignal_.emit();
    }
}

IBackendApi::DevicesMap IndirectAccountDevices::devices() const noexcept {
    std::lock_guard<std::mutex> lock(mutex_);
    return devices_;
}

std::optional<IBackendApi::Device> IndirectAccountDevices::at(const DeviceId& id) const {
    std::lock_guard<std::mutex> lock(mutex_);
    auto iter = devices_.find(id);
    if (iter != std::end(devices_)) {
        return iter->second;
    }
    return std::nullopt;
}
