#pragma once

#include "i_account_devices.h"

#include <yandex_io/libs/signals/signal_external.h>

namespace glagol {

    /*! class to implement AccountDevices via syncd message
     */
    class IndirectAccountDevices: public IAccountDevices {
    public:
        using IDeviceListChangedSignal = IAccountDevices::IDeviceListChangedSignal;

        IndirectAccountDevices();
        void update(IBackendApi::DevicesMap /*newDevices*/);
        IBackendApi::DevicesMap devices() const noexcept override;
        std::optional<IBackendApi::Device> at(const DeviceId& /*id*/) const; // returns one device instead of whole map

        IDeviceListChangedSignal& deviceListChangedSignal() noexcept override {
            return deviceListChangedSignal_;
        }
        bool setSettings(const BackendSettings& /*settings*/) override {
            return true;
        }
        bool resumeUpdate() noexcept override {
            return true;
        };
        bool scheduleUpdate() noexcept override {
            return true;
        };

    private:
        quasar::Lifetime lifetime_;
        mutable std::mutex mutex_;
        IBackendApi::DevicesMap devices_;
        quasar::SignalExternal<IDeviceListChangedSignal> deviceListChangedSignal_;
    };

} // namespace glagol
