#include "resolve_item.h"

#include <functional>

std::size_t glagol::ResolveItem::Hasher::operator()(const glagol::ResolveItem& item) const {
    std::hash<std::string> hashFn;
    return hashFn(item.name) ^ hashFn(item.type) ^ hashFn(item.domain);
}

bool glagol::ResolveItem::Info::operator==(const Info& another) const {
    return hostname == another.hostname && port == another.port && address == another.address && txt == another.txt;
}

bool glagol::ResolveItem::Info::operator!=(const Info& another) const {
    return !(*this == another);
}

bool glagol::ResolveItem::operator==(const ResolveItem& another) const {
    return name == another.name && type == another.type && domain == another.domain;
}
