#pragma once

#include <map>
#include <string>

namespace glagol {

    struct ResolveItem {
        std::string name;
        std::string type;
        std::string domain;

        enum SourceFlag: unsigned {
            MDNS = 1,
            PEERS_EXCHANGE = 2
        };

        struct Info {
            std::string hostname;
            int port;
            std::string address;
            using StringMap = std::map<std::string, std::string>;
            StringMap txt;
            unsigned source{SourceFlag::MDNS};

            bool operator==(const Info& /*another*/) const;
            bool operator!=(const Info& /*another*/) const;
        };

        struct Hasher {
            std::size_t operator()(const ResolveItem& item) const;
        };

        bool operator==(const ResolveItem& /*another*/) const;
    };

} // namespace glagol
