#pragma once

#include "gogol_generator.h"

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/http_client/http_client.h>

#include <atomic>
#include <memory>
#include <optional>

namespace quasar::gogol {

    class IGogolMetricsSender {
    public:
        virtual ~IGogolMetricsSender() = default;
        virtual void sendMetric(Json::Value json) = 0;
        virtual void setQueueSize(std::optional<int> size) = 0;
    };

    /**
     * @brief simple implementation which sends metrics to gogol
     *        and never give up: retries network errors until
     *        metrica is sent
     */
    class GogolMetricsSender: public IGogolMetricsSender {
    public:
        GogolMetricsSender(std::shared_ptr<YandexIO::IDevice> device, int queueSize, bool keepAlive);
        ~GogolMetricsSender();

        void sendMetric(Json::Value json) override;
        void setQueueSize(std::optional<int> size) override;
        void setKeepAlive(bool keepAlive);

    private:
        const int defaultQueueSize_;
        int queueSize_;
        std::atomic_bool stopped_{false};

        HttpClient httpClient_;
        NamedCallbackQueue worker_{"gogol_sender"};
    };

} // namespace quasar::gogol
