#pragma once

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/libs/bluetooth/bluetooth_capabilities.h>
#include <yandex_io/libs/bluetooth/bluetooth_le.h>
#include <yandex_io/libs/device_cryptography/device_cryptography.h>
#include <yandex_io/libs/iot/i_iot_discovery_provider.h>

#include <json/json.h>

#include <chrono>
#include <memory>
#include <optional>
#include <string>

namespace YandexIO {

    class HAL {
    public:
        virtual ~HAL();

        struct HALInfo {
            enum class PlatformType: uint8_t {
                UNKNOWN = 0,
                YANDEXSTATION = 1,
                YANDEXSTATION_2 = 2,
                YANDEXMINI = 3,
                YANDEXMINI_2 = 4,
                YANDEXMINI_2_NO_CLOCK = 6,
                YANDEXMICRO = 5,
                YANDEXMIDI = 7,
                SATURN = 8
                // next free number = 9
            };
            PlatformType platformType;
            uint16_t manufacturerId;
            uint8_t deviceColorChar;
        };

        virtual std::optional<HALInfo> getHALInfo() = 0;

        virtual std::shared_ptr<BluetoothLE> createBluetoothLE() = 0;

        /**
         * @note `config` is a `firstrund`'s config as for now.
         */
        virtual std::unique_ptr<DeviceCryptography> createDeviceCryptography(const Json::Value& config) = 0;

        virtual quasar::BluetoothCapabilities& getBluetoothCapabilities() = 0;

        virtual std::shared_ptr<IIotDiscoveryProvider> createIotDiscoveryProvider() = 0;
    };

    using HALInfo = HAL::HALInfo;
    using HALPlatformType = HAL::HALInfo::PlatformType;
} // namespace YandexIO
