#include "null_hal.h"

#include <yandex_io/libs/bluetooth/bluetooth_capabilities_impl.h>

namespace quasar {

    std::optional<YandexIO::HALInfo> NullHAL::getHALInfo() {
        return std::nullopt;
    }

    std::shared_ptr<BluetoothLE> NullHAL::createBluetoothLE() {
        return nullptr;
    }

    std::unique_ptr<YandexIO::DeviceCryptography> NullHAL::createDeviceCryptography(const Json::Value& /*config*/) {
        return nullptr;
    }

    BluetoothCapabilities& NullHAL::getBluetoothCapabilities() {
        static BluetoothCapabilitiesImpl stub(false, false, false);
        return stub;
    }

    std::shared_ptr<YandexIO::IIotDiscoveryProvider> NullHAL::createIotDiscoveryProvider() {
        return nullptr;
    }

} /* namespace quasar */
