#pragma once

#include <yandex_io/libs/hal/hal.h>

namespace quasar {

    class NullHAL: public YandexIO::HAL {
    public:
        std::optional<YandexIO::HALInfo> getHALInfo() override;
        std::shared_ptr<BluetoothLE> createBluetoothLE() override;
        std::unique_ptr<YandexIO::DeviceCryptography> createDeviceCryptography(const Json::Value& config) override;
        BluetoothCapabilities& getBluetoothCapabilities() override;
        std::shared_ptr<YandexIO::IIotDiscoveryProvider> createIotDiscoveryProvider() override;
    };

} /* namespace quasar */
