#pragma once

#include <string>
#include <string_view>
#include <vector>
#include <map>
#include <functional>
#include <cstdint>

namespace quasar {
    class ISimpleHttpClient {
    public:
        using Header = std::pair<std::string, std::string>;
        using Headers = std::map<std::string, std::string>;

        struct HttpResponse {
            HttpResponse();
            HttpResponse(int code, std::string contentType, std::string body = "", std::vector<Header> extraHeaders = {});

            int responseCode;
            std::string responseStatus;
            std::string contentType;
            std::string body;
            int64_t contentLength;
            std::vector<Header> extraHeaders;
            bool sendBody;
        };

        virtual ~ISimpleHttpClient() = default;

        // Perform GET/HEAD/POST requests
        //
        // Requests are identified by a `tag`, a likely-static string name used for
        // log tracking and telemetry
        virtual HttpResponse get(std::string_view tag, const std::string& url, const Headers& headers = {}) = 0;
        virtual HttpResponse head(std::string_view tag, const std::string& url, const Headers& headers = {}) = 0;
        virtual HttpResponse post(std::string_view tag, const std::string& url, const std::string& data, const Headers& headers = {}) = 0;
    };
} // namespace quasar
