#pragma once

#include <yandex_io/libs/http_client/i_http_client.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace quasar::mock {

    class MockHttpClient: public quasar::IHttpClient {
    public:
        MOCK_METHOD(HttpResponse, get, (std::string_view, const std::string&, const Headers&), (override));
        MOCK_METHOD(HttpResponse, head, (std::string_view, const std::string&, const Headers&), (override));
        MOCK_METHOD(HttpResponse, post, (std::string_view, const std::string&, const std::string&, const Headers&), (override));
        MOCK_METHOD(std::vector<uint32_t>, download, (std::string_view, std::vector<DownloadFileTask>&), (override));
        MOCK_METHOD(uint32_t, download, (std::string_view, const std::string&, const std::string&, const Headers&, ProgressFunction, long, long), (override));
        MOCK_METHOD(void, cancelDownload, (), (override));
        MOCK_METHOD(void, setTimeout, (std::chrono::milliseconds), (override));
    };

} // namespace quasar::mock
